/*
 * @file oledc_fontLargeScript.h
 *
 * @author Matthew Matz
 *
 * @version 0.9
 *
 * @copyright Copyright (C) Parallax, Inc. 2016.  See end of file for
 * terms of use (MIT License).
 *
 * @brief 0.96-inch RGB OLED display font component, see oledc_.h for documentation.
 *
 * @detail Please submit bug reports, suggestions, and improvements to
 * this code to editor@parallax.com.
 */


char font_lg_index[] = {   // character index of the bitfield - must be summed
0x01, 0x0E, 0x07, 0x22, 0x25, 0x27, 0x28, 0x04, 0x10, 0x0F, 0x0E, 0x0C, 0x04, 0x0A, 0x03, 0x11, 0x26, 0x15, 0x23, 0x1F, 0x18, 0x21, 0x25, 0x1B, 0x24, 0x25, 
0x07, 0x06, 0x07, 0x0B, 0x07, 0x15, 0x26, 0x23, 0x2A, 0x22, 0x29, 0x21, 0x1E, 0x25, 0x21, 0x1F, 0x1E, 0x25, 0x24, 0x27, 0x24, 0x27, 0x20, 0x28, 0x27, 
0x23, 0x19, 0x23, 0x21, 0x23, 0x29, 0x25, 0x2A, 0x16, 0x0D, 0x18, 0x07, 0x11, 0x04, 0x1B, 0x1F, 0x16, 0x20, 0x16, 0x1E, 0x1B, 0x1F, 0x14, 0x15, 0x1D, 
0x17, 0x1C, 0x19, 0x15, 0x1C, 0x18, 0x11, 0x14, 0x18, 0x19, 0x13, 0x1E, 0x19, 0x16, 0x19, 0x0E, 0x0B, 0x0F, 0x09, 
};

char font_lg_zeroMap[] = {   // 7 byte wide map of zero bytes in the font
0x00, 0x09, 0xB2, 0x4D, 0x92, 0x40, 0x00, 
0x00, 0x00, 0x49, 0x24, 0x90, 0x00, 0x00, 
0x5B, 0x6D, 0xBF, 0xFF, 0x36, 0xD2, 0x40, 
0x03, 0x6D, 0xFF, 0xFF, 0xFF, 0xF9, 0x00, 
0x13, 0xFF, 0xDB, 0x4F, 0xFF, 0xFF, 0x40, 
0xDB, 0x6D, 0xBF, 0xFF, 0xFF, 0xDA, 0x40, 
0x00, 0x00, 0x01, 0x24, 0x80, 0x00, 0x00, 
0x00, 0x0D, 0xBF, 0x24, 0x92, 0x40, 0x00, 
0x00, 0x09, 0x24, 0x9F, 0xB6, 0x00, 0x00, 
0x00, 0x02, 0xDB, 0x2D, 0x92, 0x00, 0x00, 
0x00, 0x04, 0x96, 0xC9, 0x24, 0x80, 0x00, 
0x00, 0x00, 0x04, 0x92, 0x00, 0x00, 0x00, 
0x00, 0x04, 0x92, 0x49, 0x24, 0x80, 0x00, 
0x00, 0x00, 0x04, 0x90, 0x00, 0x00, 0x00, 
0x02, 0x49, 0x36, 0x49, 0xB2, 0x48, 0x00, 
0x1B, 0x7F, 0xED, 0xB6, 0xDF, 0xFB, 0x60, 
0x00, 0x49, 0x25, 0xBF, 0xFE, 0x40, 0x00, 
0x12, 0x49, 0xFF, 0xB7, 0xFF, 0xFF, 0x00, 
0x02, 0x49, 0x6D, 0xFF, 0xFF, 0xF9, 0x00, 
0x01, 0x24, 0x92, 0xFF, 0xF6, 0xD8, 0x00, 
0x02, 0x49, 0xBF, 0xFF, 0xFF, 0xF9, 0x00, 
0x03, 0x6F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 
0x03, 0x6F, 0xFB, 0x6D, 0xB6, 0x48, 0x00, 
0x02, 0x6D, 0xFF, 0xFF, 0xFF, 0xF9, 0x00, 
0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0xD8, 0x00, 
0x00, 0x00, 0x06, 0xD9, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x24, 0xC9, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x92, 0x49, 0x20, 0x00, 0x00, 
0x00, 0x24, 0x92, 0x49, 0x24, 0x80, 0x00, 
0x00, 0x00, 0x92, 0x49, 0x20, 0x00, 0x00, 
0x00, 0x07, 0xFF, 0x6D, 0xB2, 0x40, 0x00, 
0x1B, 0x6D, 0xFF, 0xFF, 0xFF, 0xDA, 0x00, 
0xDB, 0x6C, 0x92, 0x7F, 0xFF, 0xED, 0x80, 
0x13, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0x1B, 0x6F, 0xED, 0xB7, 0xFF, 0x6C, 0x00, 
0x97, 0xFF, 0xFD, 0xB6, 0xDF, 0xFB, 0x60, 
0x13, 0x6D, 0xB7, 0xFF, 0xDB, 0x6D, 0x00, 
0x1F, 0xFE, 0xDB, 0x6D, 0xB2, 0x49, 0x00, 
0x03, 0x6F, 0xFD, 0xBF, 0xFF, 0xFB, 0x00, 
0x13, 0xFE, 0xDB, 0x7B, 0x6C, 0xDB, 0x20, 
0x92, 0xDB, 0x7F, 0xFE, 0xD2, 0x49, 0x20, 
0x13, 0x6D, 0x6D, 0xFF, 0xB6, 0x49, 0x20, 
0x97, 0xFE, 0xDF, 0xFB, 0xDB, 0x69, 0x20, 
0x92, 0x49, 0x7F, 0xFF, 0xFF, 0xF9, 0x20, 
0x9D, 0xB6, 0xFF, 0xFD, 0x7F, 0xDB, 0x20, 
0x9F, 0xF6, 0xDB, 0xFF, 0x6C, 0xD9, 0x20, 
0x1B, 0x6F, 0xED, 0xBF, 0xFB, 0xFB, 0x60, 
0x12, 0x7E, 0xDB, 0x6D, 0xB6, 0xDB, 0x60, 
0xDB, 0xFB, 0x6D, 0xB6, 0xDF, 0xFF, 0x60, 
0x12, 0x7E, 0xDF, 0xFF, 0xFF, 0xFB, 0x20, 
0x02, 0x6D, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 
0x06, 0xDF, 0xDB, 0x64, 0x92, 0x49, 0x20, 
0x37, 0xFF, 0xFD, 0x92, 0x6D, 0xF9, 0x20, 
0x26, 0xDF, 0xFF, 0xF2, 0x64, 0xDB, 0x20, 
0x36, 0xFF, 0xFF, 0xDB, 0x49, 0x9B, 0x20, 
0x9F, 0xFB, 0x7F, 0xFF, 0x6F, 0x6D, 0xA0, 
0x36, 0xFF, 0xFF, 0xDB, 0x6E, 0xD9, 0x20, 
0x92, 0x5B, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 
0x00, 0x4D, 0xBF, 0xB6, 0xD2, 0x48, 0x00, 
0x00, 0x00, 0x4B, 0x7F, 0x48, 0x00, 0x00, 
0x02, 0x49, 0x6D, 0xB7, 0xF6, 0xC8, 0x00, 
0x00, 0x00, 0x49, 0x24, 0x90, 0x00, 0x00, 
0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x80, 
0x00, 0x00, 0x01, 0x24, 0x80, 0x00, 0x00, 
0x13, 0x6D, 0xB6, 0xDB, 0x69, 0xB2, 0x00, 
0x03, 0x6D, 0xFF, 0xFF, 0xDD, 0xA0, 0x00, 
0x00, 0x6D, 0xB6, 0xDB, 0x6D, 0x80, 0x00, 
0x13, 0x6D, 0xB6, 0xDB, 0x6F, 0xED, 0x20, 
0x00, 0x6D, 0xB6, 0xDB, 0x6C, 0x90, 0x00, 
0x02, 0x6D, 0xBF, 0xEE, 0xF6, 0xE9, 0x00, 
0x03, 0x6D, 0xB7, 0xFF, 0xB4, 0x90, 0x00, 
0x13, 0x6D, 0xFB, 0xFF, 0xF9, 0x24, 0x00, 
0x00, 0x09, 0xB6, 0xFF, 0xF8, 0x00, 0x00, 
0x02, 0x49, 0x26, 0xDF, 0xB6, 0x90, 0x00, 
0x02, 0x6D, 0x9F, 0xFF, 0xFD, 0x24, 0x00, 
0x00, 0x0D, 0xB7, 0xFF, 0xF2, 0x40, 0x00, 
0xDB, 0x25, 0xB6, 0xC9, 0x6D, 0xB4, 0x80, 
0x13, 0x6D, 0x92, 0x5B, 0x6D, 0x26, 0x40, 
0x00, 0x6D, 0xB6, 0xDB, 0x6C, 0x80, 0x00, 
0x02, 0x4D, 0xFF, 0xDF, 0xB6, 0xD0, 0x00, 
0x00, 0x2D, 0xB6, 0xFF, 0xF4, 0x90, 0x00, 
0x00, 0x24, 0xB6, 0xDA, 0x49, 0x90, 0x00, 
0x00, 0x6D, 0xB6, 0xDB, 0x4C, 0x80, 0x00, 
0x00, 0x0D, 0xB7, 0xFF, 0xFC, 0x80, 0x00, 
0x03, 0x6D, 0xB4, 0xDB, 0x69, 0xB2, 0x00, 
0x00, 0x6D, 0x26, 0xCB, 0x6C, 0x90, 0x00, 
0xDB, 0x6D, 0xB6, 0xD2, 0x4C, 0xB6, 0xC0, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x90, 0x00, 
0x02, 0x6D, 0xB6, 0xDB, 0x64, 0x90, 0x00, 
0x02, 0x4D, 0xB6, 0xFF, 0xF4, 0x90, 0x00, 
0x00, 0x09, 0xB6, 0x6C, 0x92, 0x00, 0x00, 
0x00, 0x00, 0x26, 0xFD, 0x80, 0x00, 0x00, 
0x00, 0x09, 0x26, 0xED, 0xB2, 0x00, 0x00, 
0x00, 0x04, 0x92, 0x49, 0x24, 0x00, 0x00, 
};

char oled_font_lg[] = {   // bit field of the font with zero bytes removed
0x30, 0x39, 0x80, 0x19, 0xE0, 0x7C, 0x1F, 0x07, 0xE0, 0x01, 0xF8, 0x7E, 0x1F, 0x07, 0x06, 0x07, 0x03, 0x05, 0x07, 0x03, 0x01, 0x68, 
0x40, 0x2C, 0x60, 0x24, 0x7C, 0x24, 0x3F, 0xE4, 0x07, 0xFC, 0x40, 0x7F, 0xE0, 0x70, 0x27, 0xFF, 0x3F, 0x24, 0x1F, 0x1F, 0xF4, 0x01, 
0x03, 0xFF, 0x3F, 0xF8, 0x24, 0xFF, 0x24, 0x07, 0x24, 0x24, 0x24, 0x03, 0xC0, 0x07, 0xE0, 0x0F, 0xE0, 0x48, 0x21, 0xE0, 0x78, 0x07, 
0xF0, 0x3E, 0x07, 0xF8, 0x1F, 0xEF, 0x1C, 0x0F, 0xFE, 0x04, 0x08, 0x7F, 0xF4, 0x0C, 0x3F, 0xFF, 0x07, 0xF8, 0x1F, 0x03, 0xF9, 0xE2, 
0x01, 0xE1, 0xFE, 0x7C, 0x10, 0x18, 0x01, 0xF0, 0x0E, 0x03, 0xFC, 0x07, 0x02, 0x0E, 0x03, 0xC3, 0x82, 0xF1, 0xFE, 0x78, 0x7C, 0x1E, 
0x07, 0x80, 0x03, 0xE3, 0xE0, 0x07, 0xF8, 0xF8, 0x04, 0x3C, 0x3E, 0x06, 0x0C, 0x0F, 0x07, 0x84, 0x03, 0x03, 0xFC, 0x01, 0xF8, 0x03, 
0xC0, 0x0F, 0xF0, 0x0F, 0xF8, 0x1F, 0xFC, 0x1C, 0x3C, 0x18, 0x0E, 0x10, 0x06, 0xFC, 0x10, 0x03, 0xFE, 0x10, 0x03, 0xFF, 0x18, 0x02, 
0x03, 0x0C, 0x10, 0x01, 0x04, 0x18, 0x20, 0x07, 0x08, 0x30, 0x03, 0xC8, 0x3F, 0xF8, 0x1F, 0x38, 0x08, 0x0C, 0x0E, 0x06, 0x02, 0x03, 
0xF8, 0x1F, 0xFF, 0x3F, 0xFF, 0x80, 0x30, 0x07, 0xE0, 0xF0, 0x38, 0x0C, 0x06, 0x02, 0x02, 0x20, 0x30, 0x38, 0x1C, 0x0E, 0x07, 0x80, 
0x02, 0x03, 0xF0, 0x0E, 0xFF, 0xFC, 0x1F, 0xF0, 0x20, 0x02, 0x24, 0x03, 0xBC, 0x01, 0xF8, 0xF0, 0x03, 0xFC, 0x03, 0xAC, 0x24, 0x20, 
0x10, 0x10, 0x10, 0x01, 0x10, 0x01, 0xFF, 0xFF, 0x10, 0x10, 0x10, 0x10, 0x18, 0x1E, 0x0E, 0x02, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 
0x10, 0x10, 0x10, 0x10, 0x06, 0x06, 0x06, 0x40, 0x60, 0x38, 0x3E, 0x0F, 0x80, 0x03, 0xF0, 0xFC, 0x3F, 0x0F, 0xE0, 0x01, 0xF8, 0x7E, 
0x1F, 0x03, 0x07, 0xF0, 0x1F, 0xFE, 0x3F, 0xFF, 0xC0, 0x70, 0x0F, 0xE0, 0x60, 0x01, 0xF0, 0x40, 0x38, 0x40, 0x1C, 0x60, 0x06, 0x70, 
0x06, 0x38, 0x02, 0x1E, 0x02, 0x0F, 0x80, 0x06, 0x07, 0xF0, 0x0E, 0x03, 0xFF, 0xFC, 0x7F, 0xF8, 0x0F, 0xE0, 0x40, 0x40, 0x40, 0x40, 
0x60, 0x40, 0x7C, 0x40, 0x7F, 0xE0, 0x60, 0x47, 0xFE, 0x70, 0x40, 0xFF, 0xF8, 0x40, 0x0F, 0xFC, 0x7C, 0x70, 0x70, 0x50, 0x50, 0x70, 
0x01, 0xE0, 0x30, 0x01, 0xF8, 0x78, 0x01, 0xFC, 0x7E, 0x0C, 0x6F, 0x06, 0x67, 0xC0, 0x02, 0x61, 0xF0, 0x02, 0x60, 0xFE, 0x06, 0x60, 
0x3F, 0xFE, 0x70, 0x0F, 0xFC, 0x30, 0x03, 0xF0, 0x1E, 0x3F, 0x7F, 0x61, 0x78, 0x40, 0x7C, 0x40, 0x7C, 0x60, 0x08, 0x06, 0x60, 0x08, 
0x02, 0x38, 0x1C, 0x02, 0x3F, 0xFE, 0x02, 0x1F, 0xFB, 0x86, 0x0F, 0xF1, 0xFE, 0x03, 0xC0, 0xFC, 0x78, 0x20, 0x30, 0x38, 0x2C, 0x26, 
0x27, 0x7E, 0x23, 0x80, 0x7F, 0xF1, 0xC0, 0x7F, 0xFF, 0xC0, 0x01, 0xFF, 0xF0, 0x2F, 0xF8, 0x20, 0x7C, 0x20, 0x04, 0x1E, 0x3F, 0x7F, 
0x61, 0x18, 0x40, 0x1F, 0x80, 0x40, 0x17, 0xF0, 0x40, 0x10, 0x7C, 0x60, 0x30, 0x0C, 0x78, 0x70, 0x0C, 0x3F, 0xF0, 0x0C, 0x3F, 0xE0, 
0x0C, 0x1F, 0xE0, 0x0C, 0x07, 0xC0, 0x0C, 0x04, 0x0F, 0xF0, 0x1F, 0xFE, 0x3F, 0xFF, 0x80, 0x70, 0x3F, 0xE0, 0x60, 0x13, 0xF0, 0x40, 
0x18, 0x78, 0x40, 0x08, 0x1C, 0x60, 0x08, 0x0E, 0x70, 0x18, 0x06, 0x38, 0x38, 0x02, 0x3F, 0xF8, 0x02, 0x1F, 0xF0, 0x0E, 0x07, 0xE0, 
0x0C, 0x70, 0x10, 0x7E, 0x10, 0x7F, 0x90, 0x0C, 0x3F, 0xF0, 0x0C, 0x03, 0xF0, 0x0C, 0x7C, 0x0C, 0x1E, 0x0C, 0x17, 0x8C, 0x11, 0xEC, 
0x10, 0x7C, 0x10, 0x1C, 0x0C, 0x04, 0x1E, 0x3F, 0x80, 0x7F, 0xC0, 0x71, 0xE0, 0xF8, 0x60, 0x63, 0xFC, 0x40, 0x37, 0xFC, 0x40, 0x3F, 
0x06, 0x60, 0x1E, 0x02, 0x60, 0x3C, 0x02, 0x30, 0x7E, 0x02, 0x3F, 0xF3, 0x86, 0x1F, 0xE1, 0xFE, 0x07, 0x80, 0xFC, 0x78, 0x60, 0x07, 
0xE0, 0xE0, 0x1F, 0xF8, 0x80, 0x1F, 0xFC, 0x80, 0x38, 0x3C, 0xC0, 0x30, 0x0E, 0xE0, 0x20, 0x06, 0x70, 0x20, 0x02, 0x3C, 0x20, 0x02, 
0x1F, 0xB0, 0x06, 0x0F, 0xF8, 0x0E, 0x07, 0xFF, 0xFC, 0xFF, 0xF8, 0x1F, 0xE0, 0x01, 0x80, 0x01, 0x86, 0x01, 0x86, 0x06, 0x06, 0x07, 
0x01, 0x06, 0x06, 0x06, 0x20, 0x30, 0x78, 0xCC, 0x86, 0x87, 0x01, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 
0x01, 0x87, 0x86, 0xCC, 0x78, 0x30, 0x20, 0x01, 0xE0, 0x18, 0x01, 0xF8, 0x19, 0xE0, 0x1C, 0x19, 0xF0, 0x06, 0x38, 0x02, 0x0E, 0x02, 
0x07, 0x06, 0x01, 0xFE, 0xFC, 0x78, 0x01, 0xF0, 0x03, 0xFC, 0x06, 0x0F, 0x0D, 0xE3, 0x09, 0xF1, 0x80, 0x09, 0x38, 0x80, 0x09, 0x8C, 
0xC0, 0x08, 0xC6, 0x40, 0x08, 0xE2, 0x40, 0x0D, 0xFA, 0x40, 0x07, 0x1E, 0x40, 0x03, 0x8C, 0xC0, 0x02, 0xE1, 0x80, 0x7F, 0x80, 0x1E, 
0x78, 0x20, 0x7E, 0x30, 0x3F, 0x90, 0x0F, 0xD0, 0x03, 0xF0, 0xF8, 0x3C, 0x37, 0x23, 0x80, 0x1F, 0xF0, 0xC0, 0x3F, 0xFE, 0x70, 0x3F, 
0xFF, 0xF0, 0x20, 0x7F, 0xF8, 0x30, 0x03, 0xFC, 0x1C, 0x7C, 0x0E, 0x0C, 0x02, 0x6C, 0x7F, 0x80, 0x7F, 0xF0, 0x04, 0x63, 0xFF, 0x04, 
0x60, 0x3F, 0xE4, 0x60, 0x08, 0xFE, 0x60, 0x08, 0x1E, 0x30, 0x0C, 0x06, 0x30, 0x0C, 0x02, 0x38, 0x0C, 0x02, 0x18, 0x0E, 0x06, 0x1C, 
0x1B, 0x0E, 0x0E, 0x39, 0xFC, 0x07, 0xF1, 0xFC, 0x03, 0xE0, 0xF8, 0x0F, 0xE0, 0x1F, 0xFC, 0x3F, 0xFF, 0x70, 0x1F, 0xC0, 0x60, 0x03, 
0xE0, 0x40, 0xF0, 0x40, 0x38, 0x40, 0x1C, 0x60, 0x0E, 0x20, 0x01, 0x06, 0x30, 0x01, 0x82, 0x1C, 0x01, 0xE2, 0x0E, 0xFE, 0x03, 0x3C, 
0x01, 0x30, 0x7F, 0xE0, 0x7F, 0xE0, 0xF0, 0x47, 0xFC, 0x18, 0x40, 0xFF, 0x8C, 0x40, 0x0F, 0xF4, 0x60, 0x01, 0xFE, 0x20, 0x3A, 0x30, 
0x0A, 0x18, 0x02, 0x1C, 0x02, 0x0F, 0x06, 0x07, 0x80, 0x0E, 0x03, 0xF0, 0x1C, 0x01, 0xFF, 0xFC, 0x7F, 0xF8, 0x0F, 0xE0, 0x0F, 0x1F, 
0xC0, 0x3F, 0xE0, 0x7F, 0xF0, 0x70, 0xF0, 0x60, 0x38, 0x40, 0x1B, 0xF0, 0x40, 0x0F, 0xF8, 0x40, 0x0F, 0xFC, 0x60, 0x08, 0x0E, 0x30, 
0x06, 0x18, 0x82, 0x0C, 0xE2, 0x07, 0xFE, 0x03, 0x3C, 0x78, 0x10, 0xF0, 0x7F, 0x10, 0xF8, 0x7F, 0xF0, 0x08, 0x0F, 0xF8, 0x0C, 0xFF, 
0x04, 0x1F, 0xE4, 0x13, 0xFC, 0x10, 0x7C, 0x10, 0x04, 0x10, 0x0C, 0x10, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x07, 0xF0, 0x1F, 0xFE, 0x3F, 
0xFF, 0x80, 0x70, 0x1F, 0xC0, 0x60, 0x03, 0xE0, 0x40, 0xF8, 0x40, 0x38, 0x60, 0x20, 0x1C, 0x30, 0x20, 0x0E, 0x38, 0x20, 0x06, 0x7E, 
0x20, 0x82, 0x7F, 0xE0, 0xE2, 0x03, 0xC0, 0xFE, 0x40, 0x7C, 0x70, 0x7E, 0x20, 0xF0, 0x3F, 0xF0, 0xF8, 0x07, 0xF8, 0x1C, 0x7F, 0x06, 
0x0F, 0xE2, 0x09, 0xFE, 0x08, 0x1E, 0x3E, 0x08, 0x7F, 0xD8, 0x7F, 0xF0, 0x03, 0xFE, 0x1F, 0xE0, 0x13, 0xFC, 0x10, 0x3E, 0x02, 0x40, 
0x60, 0x60, 0x08, 0x60, 0x08, 0x60, 0x0C, 0x7C, 0x06, 0x7F, 0xC0, 0x06, 0x67, 0xFC, 0x06, 0x61, 0xFF, 0xC6, 0x40, 0x0F, 0xFE, 0x40, 
0x7E, 0x40, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x3E, 0x7F, 0x80, 0x7F, 0x80, 0x60, 0x80, 0x40, 0x08, 0x60, 0x08, 0x3C, 0x0C, 0x1F, 
0x80, 0x04, 0x07, 0xF8, 0x04, 0x01, 0xFF, 0xC4, 0x1F, 0xFC, 0x01, 0xFC, 0x04, 0x04, 0x04, 0x04, 0x60, 0x7C, 0xE0, 0x3F, 0x80, 0xF8, 
0x0F, 0xF0, 0x1C, 0x01, 0xFE, 0x0C, 0x3F, 0x86, 0xFF, 0xF2, 0x01, 0xE6, 0x7E, 0x07, 0x87, 0x0E, 0x0F, 0x03, 0x3C, 0x01, 0x80, 0x38, 
0xC0, 0x70, 0xE0, 0x60, 0x70, 0x40, 0x3C, 0x1E, 0x06, 0x18, 0x38, 0x28, 0x38, 0x18, 0x1E, 0xE0, 0x1F, 0xC1, 0xE0, 0x31, 0xFB, 0x20, 
0x30, 0x7F, 0x80, 0x70, 0x0F, 0xF0, 0x60, 0x05, 0xF8, 0x60, 0x06, 0x7C, 0x60, 0x03, 0x0E, 0x60, 0x01, 0x86, 0x20, 0x01, 0xC2, 0xFE, 
0x3C, 0x3C, 0x07, 0x83, 0xC0, 0xF9, 0xF0, 0x3E, 0x18, 0x07, 0x8C, 0x01, 0xE4, 0x0F, 0xF0, 0x7C, 0x1F, 0xFF, 0xFC, 0x1F, 0xFF, 0xFC, 
0x03, 0xFF, 0xF0, 0x1E, 0x3F, 0x87, 0x80, 0x7F, 0xFD, 0xC0, 0x7F, 0xFF, 0xE0, 0xFF, 0xF8, 0x03, 0xFC, 0x3C, 0x60, 0x7C, 0x01, 0xE0, 
0x3F, 0xC1, 0xF0, 0x03, 0xF8, 0x38, 0x7F, 0x8C, 0x0F, 0xF4, 0x01, 0xFC, 0x1F, 0xFC, 0x07, 0xFF, 0xF8, 0x7F, 0xFF, 0xC0, 0x7F, 0xC0, 
0x7F, 0xC0, 0x07, 0xFC, 0x3F, 0x80, 0x07, 0xF0, 0x7C, 0x0C, 0x0F, 0xE0, 0x1F, 0xFC, 0x3F, 0xFF, 0x70, 0x1F, 0x80, 0x60, 0x03, 0xC0, 
0x40, 0xF0, 0x40, 0x70, 0x40, 0x38, 0x60, 0x03, 0x9C, 0x30, 0x03, 0xEC, 0x18, 0x01, 0xF4, 0x0E, 0x3C, 0x07, 0x80, 0x1C, 0x03, 0xF0, 
0x18, 0xFF, 0xF8, 0x1F, 0xE0, 0x78, 0x7F, 0x7F, 0xE0, 0x08, 0x0F, 0xFC, 0x0C, 0xFF, 0x84, 0x1F, 0xE4, 0x11, 0xFE, 0x10, 0x3E, 0x10, 
0x06, 0x18, 0x02, 0x0C, 0x06, 0x0C, 0x04, 0x07, 0x0C, 0x07, 0xFC, 0x03, 0xF8, 0x01, 0xF0, 0x01, 0xF8, 0x03, 0xFF, 0x03, 0xFF, 0xC0, 
0x1C, 0x07, 0xF0, 0x3C, 0xF8, 0x24, 0x3C, 0x24, 0x0E, 0x2C, 0x06, 0x38, 0x03, 0x38, 0x01, 0x7C, 0x01, 0x7F, 0x01, 0x67, 0xC0, 0x03, 
0x63, 0xFC, 0x07, 0x60, 0xFF, 0xFE, 0x60, 0x3F, 0xFC, 0x07, 0xF0, 0x78, 0x7F, 0x7F, 0xE0, 0x08, 0x0F, 0xF8, 0x0C, 0xFF, 0x04, 0xFF, 
0xE4, 0x03, 0xF1, 0xFE, 0x07, 0x98, 0x3E, 0x1E, 0x08, 0x06, 0x3C, 0x08, 0x02, 0x78, 0x0C, 0x06, 0xE0, 0x06, 0x04, 0xC0, 0x07, 0x0C, 
0x80, 0x03, 0xFC, 0x03, 0xF8, 0xF0, 0x0F, 0x3F, 0x80, 0x3F, 0x80, 0x70, 0x83, 0xC0, 0x60, 0x8F, 0xF0, 0x40, 0x0F, 0xF8, 0x40, 0x1C, 
0x3C, 0x40, 0x38, 0x0E, 0x60, 0x78, 0x06, 0x30, 0xF0, 0x02, 0x3F, 0xE3, 0xC2, 0x1F, 0xC3, 0xFE, 0x0F, 0x80, 0x7C, 0x0C, 0x78, 0x0C, 
0x7F, 0x06, 0x7F, 0xE0, 0x06, 0x07, 0xFC, 0x06, 0x7F, 0x86, 0x0F, 0xE6, 0x01, 0xFE, 0x3E, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 
0xF8, 0x1E, 0xFC, 0x3F, 0xE0, 0x0E, 0x7F, 0xF8, 0x02, 0x60, 0xFF, 0x82, 0x40, 0x1F, 0xFE, 0x40, 0x03, 0xFE, 0x60, 0x7C, 0x38, 0x1C, 
0x7F, 0xFF, 0xF0, 0xFF, 0xFF, 0xC0, 0xFF, 0xE0, 0x80, 0x07, 0xFC, 0xFE, 0x1E, 0x70, 0xF8, 0x3C, 0xFC, 0x7F, 0x0E, 0x7F, 0xE0, 0x02, 
0x43, 0xFC, 0x02, 0x60, 0xFF, 0xFE, 0x20, 0x1F, 0xFC, 0x18, 0x03, 0xF8, 0x0E, 0x07, 0x03, 0xC0, 0xF0, 0x7E, 0x0C, 0x1F, 0xFC, 0x07, 
0xFC, 0xF8, 0x70, 0x3C, 0xFC, 0x7F, 0x0E, 0x7F, 0xE0, 0x02, 0x43, 0xFC, 0x02, 0x60, 0xFF, 0xFE, 0x20, 0x1F, 0xFC, 0x3F, 0x83, 0xF8, 
0x7F, 0xE0, 0x43, 0xFC, 0x60, 0x7C, 0x18, 0x07, 0x03, 0xC0, 0x7E, 0x0C, 0x1F, 0xFC, 0xF8, 0xC0, 0xE0, 0x01, 0xE0, 0x30, 0x01, 0xF0, 
0x18, 0x01, 0xF8, 0x0E, 0x1C, 0x07, 0x04, 0x01, 0x80, 0x0C, 0x07, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x7F, 0xFF, 0xF0, 0x7C, 0x0E, 0x60, 
0x07, 0x40, 0x01, 0xC0, 0x70, 0xF0, 0x3C, 0x7E, 0x0F, 0x1E, 0x03, 0x04, 0x1E, 0x38, 0x3F, 0x78, 0x03, 0xC8, 0x3E, 0x01, 0x80, 0x7F, 
0xE1, 0x80, 0x7F, 0xFF, 0x80, 0x60, 0xFF, 0xC0, 0x40, 0x0E, 0xE0, 0x60, 0x78, 0x30, 0x3F, 0x18, 0x1F, 0xFC, 0x03, 0xFF, 0x80, 0x7F, 
0xF8, 0x07, 0xFE, 0x7F, 0x0F, 0x38, 0x78, 0x48, 0x78, 0x78, 0x38, 0x7C, 0x18, 0x06, 0x1C, 0x10, 0x02, 0x1E, 0x18, 0x02, 0x37, 0x88, 
0x02, 0x33, 0xC8, 0x02, 0x71, 0xF8, 0x06, 0x60, 0x78, 0x06, 0x60, 0x3E, 0x0E, 0x60, 0x1F, 0x8C, 0x60, 0x0F, 0xFC, 0x20, 0x19, 0xFC, 
0x20, 0x10, 0x78, 0x7C, 0x7F, 0xE0, 0x4F, 0xFF, 0x40, 0x7F, 0xF0, 0x40, 0x01, 0xF8, 0x40, 0x1C, 0x40, 0x0C, 0x60, 0x0C, 0x20, 0x0C, 
0x0C, 0x0C, 0x04, 0x01, 0x3F, 0x07, 0xFE, 0xFF, 0xF8, 0x0F, 0xFF, 0x80, 0x3F, 0xF0, 0x7E, 0x60, 0x40, 0x40, 0x40, 0x40, 0x08, 0x40, 
0x0C, 0x40, 0x04, 0x40, 0x04, 0x78, 0x04, 0x3F, 0xC0, 0x04, 0x0F, 0xFE, 0x04, 0x7F, 0xFC, 0x01, 0xFC, 0x08, 0x40, 0x60, 0x30, 0x30, 
0x70, 0xE0, 0xC0, 0x10, 0x18, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x08, 0x08, 0x08, 0x08, 0x10, 0x30, 
0xF0, 0xC0, 0x07, 0x0F, 0xC0, 0x0F, 0xE0, 0x08, 0xF0, 0x0C, 0x38, 0x06, 0x1C, 0x07, 0x0C, 0x0F, 0x84, 0x0F, 0xE4, 0x08, 0xFC, 0x0C, 
0x58, 0x06, 0x03, 0xC0, 0x01, 0xC0, 0x80, 0x1F, 0x80, 0x3F, 0xF0, 0x3F, 0xFC, 0x20, 0x7F, 0x80, 0x31, 0xFF, 0xE0, 0x3B, 0xFE, 0xF0, 
0x1E, 0x17, 0xBC, 0x07, 0xF1, 0xFE, 0x05, 0xE0, 0x7E, 0x04, 0x1E, 0x07, 0x80, 0x03, 0x80, 0x01, 0x07, 0x80, 0x0F, 0xE0, 0x1F, 0xF0, 
0x18, 0x78, 0x10, 0x1C, 0x10, 0x0C, 0x18, 0x24, 0x0C, 0x3C, 0x06, 0x38, 0x03, 0x80, 0x01, 0x80, 0x0E, 0x1F, 0x80, 0x1F, 0xC0, 0x11, 
0xE0, 0x18, 0x70, 0x0C, 0x38, 0x06, 0x18, 0x0F, 0x88, 0x1F, 0xE8, 0x1F, 0xF8, 0x10, 0x7F, 0x18, 0x0F, 0xC0, 0x0C, 0x03, 0xF0, 0x07, 
0xFC, 0x03, 0x3E, 0x0E, 0x07, 0x80, 0x0F, 0xE0, 0x0F, 0xF0, 0x0D, 0xF8, 0x08, 0x98, 0x08, 0xCC, 0x0C, 0x64, 0x06, 0x3C, 0x03, 0x1C, 
0x01, 0x80, 0xC0, 0x40, 0xF8, 0xFF, 0x80, 0xFF, 0xF0, 0xC7, 0xFE, 0xF8, 0x7F, 0x80, 0x3F, 0xFF, 0xE0, 0x07, 0xFD, 0xF8, 0xC0, 0xFE, 
0x01, 0xDE, 0x01, 0x80, 0x67, 0xE0, 0x3B, 0xC0, 0x3F, 0x01, 0x1F, 0x0E, 0xE0, 0x70, 0xF0, 0xFC, 0x98, 0xFE, 0xE8, 0x8F, 0x7C, 0xC3, 
0x3E, 0x61, 0x80, 0x0F, 0xF1, 0x80, 0x03, 0xFE, 0x80, 0x01, 0xFE, 0x80, 0x8E, 0x80, 0xE0, 0x70, 0x10, 0x1F, 0x3F, 0xE0, 0x3F, 0xF8, 
0x1F, 0xFE, 0x07, 0xBF, 0x80, 0x01, 0xDB, 0xE0, 0xEE, 0xF0, 0x1C, 0x67, 0x78, 0x3F, 0xE3, 0xDC, 0x3F, 0xE0, 0xFC, 0x23, 0xC0, 0x3C, 
0x30, 0x18, 0x0E, 0x06, 0x1E, 0x3F, 0x80, 0x3F, 0xE0, 0x21, 0xF0, 0x20, 0x71, 0x80, 0x30, 0x11, 0x80, 0x1C, 0x01, 0x80, 0x0E, 0x01, 
0x80, 0x02, 0xE0, 0xF0, 0xD8, 0xEC, 0x7C, 0x1F, 0x10, 0x07, 0xFE, 0x01, 0xFF, 0x8C, 0x01, 0x9F, 0x8C, 0xC1, 0x8C, 0x70, 0x0C, 0x30, 
0x10, 0x3F, 0x3F, 0xE0, 0x3F, 0xF8, 0x07, 0xFF, 0xFF, 0xC0, 0x0E, 0x67, 0xE0, 0x3E, 0x37, 0x78, 0x3B, 0x11, 0xFC, 0x21, 0xF0, 0xFC, 
0x31, 0xF0, 0x3C, 0x18, 0xE0, 0x0E, 0x06, 0x02, 0x07, 0xC0, 0x0F, 0xF8, 0x0F, 0xFE, 0x08, 0x3F, 0x80, 0x0C, 0x1F, 0xE0, 0x06, 0x0E, 
0x78, 0x03, 0x83, 0x9E, 0x01, 0x81, 0xFF, 0x7F, 0x0F, 0x0F, 0x80, 0x0F, 0xF0, 0x03, 0xF8, 0xF8, 0x70, 0x04, 0x18, 0x0F, 0x8C, 0x0F, 
0xFC, 0x03, 0xFC, 0xFC, 0x20, 0x07, 0x30, 0x0F, 0xF0, 0x0F, 0xF0, 0x08, 0xF0, 0x0C, 0x07, 0x0C, 0x0F, 0x80, 0x0F, 0xF0, 0x03, 0xF0, 
0x01, 0xF0, 0x60, 0x30, 0x10, 0x07, 0x18, 0x0F, 0xF8, 0x0F, 0xF8, 0x08, 0xF0, 0x0C, 0x07, 0x03, 0x80, 0x80, 0x07, 0x80, 0x0F, 0xE0, 
0x0F, 0xF0, 0x08, 0x70, 0x0E, 0xF8, 0x07, 0xFC, 0x01, 0xCC, 0x01, 0x7C, 0x01, 0x3C, 0x01, 0xC0, 0xC0, 0xF0, 0xFE, 0x3F, 0xF0, 0x07, 
0xFF, 0xC0, 0x01, 0x7F, 0xC0, 0x01, 0x0F, 0xC0, 0x01, 0x83, 0x01, 0x81, 0x80, 0x01, 0xC0, 0x80, 0xF0, 0x80, 0x7F, 0x80, 0x3F, 0x80, 
0x0F, 0xE0, 0x01, 0xF8, 0x01, 0xFE, 0x01, 0x0E, 0x01, 0xC3, 0xFF, 0xC1, 0x80, 0xFF, 0xF0, 0x80, 0x7F, 0x3C, 0x80, 0x01, 0x8F, 0x80, 
0xC7, 0x70, 0x30, 0xC0, 0xF8, 0x3F, 0x07, 0x0F, 0x0F, 0xFC, 0x0F, 0xF8, 0x08, 0xF0, 0x0C, 0x06, 0x03, 0x01, 0x80, 0x80, 0x03, 0x80, 
0x0F, 0xC0, 0x0D, 0xF0, 0x0B, 0x38, 0x0E, 0x1F, 0x0F, 0xFF, 0x07, 0xF8, 0x03, 0xC0, 0x03, 0x01, 0xC0, 0xC0, 0x07, 0xC0, 0x0F, 0xFC, 
0x0F, 0xFE, 0x08, 0x3F, 0x80, 0x08, 0x07, 0xE0, 0x0C, 0x05, 0xF0, 0x06, 0x04, 0x78, 0x03, 0x04, 0x18, 0x01, 0xC4, 0xC4, 0x07, 0x80, 
0x0F, 0xE0, 0x0F, 0xF8, 0x0C, 0x78, 0x06, 0x08, 0x07, 0x0F, 0xC0, 0x0F, 0xF0, 0x08, 0xF0, 0x0C, 0x10, 0x06, 0x03, 0x80, 0x01, 0x80, 
0x80, 0x0F, 0xF0, 0x0F, 0xF0, 0x08, 0x0E, 0x07, 0x80, 0x01, 0xC0, 0xFC, 0x01, 0xFC, 0x01, 0x0C, 0x01, 0x80, 0xC0, 0x40, 0x07, 0x80, 
0x0F, 0xE0, 0x0F, 0xF8, 0x0C, 0x38, 0x07, 0x08, 0x03, 0x80, 0x07, 0xF0, 0x0F, 0xF8, 0x08, 0x18, 0x0C, 0x06, 0x03, 0x01, 0xC0, 0xFC, 
0x01, 0xFC, 0x01, 0x0C, 0x01, 0x80, 0x10, 0xC0, 0x18, 0xE0, 0x0C, 0x30, 0x06, 0x18, 0x03, 0x18, 0x03, 0xF8, 0x0F, 0xF8, 0x0F, 0xF0, 
0x08, 0x18, 0x0C, 0x0C, 0x07, 0x04, 0x03, 0x84, 0x80, 0xE0, 0xF0, 0x78, 0x98, 0xFE, 0xE8, 0xFF, 0xFC, 0x8F, 0x7C, 0xC1, 0x1F, 0xE0, 
0x07, 0xF0, 0x01, 0xFE, 0x01, 0xBE, 0xC6, 0x70, 0x30, 0xE0, 0xF0, 0x98, 0x18, 0xC8, 0x1C, 0xCC, 0x06, 0x64, 0x23, 0x7E, 0x61, 0x80, 
0x3F, 0xF8, 0x80, 0x1F, 0xDF, 0x80, 0x0F, 0x8F, 0x80, 0xC7, 0x70, 0x30, 0x78, 0x7E, 0x08, 0x47, 0xF8, 0x43, 0xFF, 0xF7, 0xFC, 0x03, 
0xFE, 0x0E, 0x06, 0x04, 0x40, 0x7F, 0x80, 0x3F, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0x01, 0xFF, 0x20, 0x20, 0x3E, 0x3F, 0xF0, 0x0F, 0xFB, 
0x80, 0x1F, 0xF2, 0x0F, 0xFE, 0x08, 0x3E, 0x0E, 0x80, 0x40, 0x20, 0x10, 0x30, 0x20, 0x20, 0x10, 0x08
};  



/**
 * TERMS OF USE: MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
